IF OBJECT_ID('V_EST_PROD_TBL_DESC_CARGO_MULTIPDV') IS NOT NULL
BEGIN
	DROP VIEW V_EST_PROD_TBL_DESC_CARGO_MULTIPDV
END

GO
GO

CREATE VIEW
	V_EST_PROD_TBL_DESC_CARGO_MULTIPDV
AS

--PRODUTO
SELECT
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL,
	EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD AS CD_PROD,
	EST_PROD_TBL_DESC_CARGO_EST_PROD.PERC_DESC
FROM
	EST_PROD_TBL_DESC_CARGO 
	INNER JOIN EST_PROD_TBL_DESC_CARGO_PRC_FILIAL ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_PROD ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_TBL_DESC_CARGO
WHERE
	EST_PROD_TBL_DESC_CARGO.STS_TBL IN (0,1)

UNION



--FAMILIA
SELECT
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL,
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD AS CD_PROD,
	EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.PERC_DESC
FROM
	EST_PROD_TBL_DESC_CARGO 
	INNER JOIN EST_PROD_TBL_DESC_CARGO_PRC_FILIAL ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
		EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
		AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA = EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_FAMILIA
WHERE
	EST_PROD_TBL_DESC_CARGO.STS_TBL IN (0,1)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_PROD
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_TBL_DESC_CARGO
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)

UNION


--MARCA
SELECT
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL,
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD AS CD_PROD,
	EST_PROD_TBL_DESC_CARGO_EST_MC.PERC_DESC
FROM
	EST_PROD_TBL_DESC_CARGO 
	INNER JOIN EST_PROD_TBL_DESC_CARGO_PRC_FILIAL ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_MC ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_MC.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
		EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
		AND EST_PROD_TBL_DESC_CARGO_EST_MC.CD_MC = EST_PROD_EST_ARV_MERCADOLOGICA.CD_MC
WHERE
	EST_PROD_TBL_DESC_CARGO.STS_TBL IN (0,1)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_PROD
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_MC.CD_TBL_DESC_CARGO
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = ARV.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_MC.CD_TBL_DESC_CARGO
			AND ARV.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)

UNION


--FABRICANTE
SELECT
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL,
	EST_PROD.CD_PROD AS CD_PROD,
	EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.PERC_DESC
FROM
	EST_PROD_TBL_DESC_CARGO 
	INNER JOIN EST_PROD_TBL_DESC_CARGO_PRC_FILIAL ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD ON
		EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP = EST_PROD.CD_EMP
		AND EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_FABRIC = EST_PROD.CD_FABRIC
WHERE
	EST_PROD_TBL_DESC_CARGO.STS_TBL IN (0,1)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_PROD
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_TBL_DESC_CARGO
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD = EST_PROD.CD_PROD)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_TBL_DESC_CARGO
			AND ARV.CD_PROD = EST_PROD.CD_PROD)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_MC
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP = ARV.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_MC.CD_MC = ARV.CD_MC
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_MC.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_TBL_DESC_CARGO
			AND ARV.CD_PROD = EST_PROD.CD_PROD)



UNION


--CATEGORIA
SELECT
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL,
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD AS CD_PROD,
	EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.PERC_DESC
FROM
	EST_PROD_TBL_DESC_CARGO 
	INNER JOIN EST_PROD_TBL_DESC_CARGO_PRC_FILIAL ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
		EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
		AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_CATEG = EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_CATEG
WHERE
	EST_PROD_TBL_DESC_CARGO.STS_TBL IN (0,1)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_PROD
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_TBL_DESC_CARGO
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = ARV.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_TBL_DESC_CARGO
			AND ARV.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_MC
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP = ARV.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_MC.CD_MC = ARV.CD_MC
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_MC.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_TBL_DESC_CARGO
			AND ARV.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC
			INNER JOIN EST_PROD ON
				EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP = EST_PROD.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_FABRIC = EST_PROD.CD_FABRIC
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_EMP AND 
			EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_TBL_DESC_CARGO
			AND EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)




UNION

--LINHA
SELECT
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL,
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD AS CD_PROD,
	EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.PERC_DESC
FROM
	EST_PROD_TBL_DESC_CARGO 
	INNER JOIN EST_PROD_TBL_DESC_CARGO_PRC_FILIAL ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA ON
		EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_EMP AND 
		EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_TBL_DESC_CARGO
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
		EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
		AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA = EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA
WHERE
	EST_PROD_TBL_DESC_CARGO.STS_TBL IN (0,1)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_PROD
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_TBL_DESC_CARGO
			AND EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = ARV.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_TBL_DESC_CARGO
			AND ARV.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_MC
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP = ARV.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_MC.CD_MC = ARV.CD_MC
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_MC.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_MC.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_TBL_DESC_CARGO
			AND ARV.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC
			INNER JOIN EST_PROD ON
				EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP = EST_PROD.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_FABRIC = EST_PROD.CD_FABRIC
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_EMP AND 
			EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_TBL_DESC_CARGO
			AND EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)
	AND NOT EXISTS(
		SELECT
			*
		FROM
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_EMP = ARV.CD_EMP
				AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG
		WHERE
			EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_EMP
			AND EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA.CD_TBL_DESC_CARGO
			AND ARV.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD)





